#! /usr/bin/env python
# -*- coding: Latin-1 -*-

# Dfinition d'un serveur rseau grant un systme de CHAT simplifi.
# Utilise les threads pour grer les connexions clientes en parallle.

HOST = '192.168.0.235'
PORT = 40000

import socket, sys, threading

class ThreadClient(threading.Thread):
    '''drivation d'un objet thread pour grer la connexion avec un client'''
    def __init__(self, conn):
        threading.Thread.__init__(self)
        self.connexion = conn
        
    def run(self):
        # Dialogue avec le client :
        nom = self.getName()            # Chaque thread possde un nom
        while 1:
            msgClient = self.connexion.recv(1024)
            if msgClient.upper() == "FIN" or msgClient =="":
                break
            message = "%s> %s" % (nom, msgClient)
            print message
            # Faire suivre le message  tous les autres clients :
            for cle in conn_client:
                if cle != nom:          # ne pas le renvoyer  l'metteur
                    conn_client[cle].send(message)
                    
        # Fermeture de la connexion :
        self.connexion.close()      # couper la connexion ct serveur
        del conn_client[nom]        # suppr. son entre dans le dictionnaire
        print "Client %s dconnect." % nom
        # Le thread se termine ici    

# Initialisation du serveur - Mise en place du socket :
mySocket = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
try:
    mySocket.bind((HOST, PORT))
except socket.error:
    print "La liaison du socket  l'adresse choisie a chou."
    sys.exit()
print "Serveur prt, en attente de requtes ..."
mySocket.listen(5)

# Attente et prise en charge des connexions demandes par les clients :
conn_client = {}                # dictionnaire des connexions clients
while 1:    
    connexion, adresse = mySocket.accept()
    # Crer un nouvel objet thread pour grer la connexion :
    th = ThreadClient(connexion)
    th.start()
    # Mmoriser la connexion dans le dictionnaire : 
    it = th.getName()        # identifiant du thread
    conn_client[it] = connexion
    print "Client %s connect, adresse IP %s, port %s." %\
           (it, adresse[0], adresse[1])
    # Dialogue avec le client :
    connexion.send("Vous tes connect. Envoyez vos messages.")
