#! /usr/bin/env python
# -*- coding: Latin-1 -*-

class Application:
    def __init__(self):
        """Constructeur de la fentre principale"""
        self.root =Tk()
        self.root.title('Code des couleurs')
        self.dessineResistance()
        Label(self.root,
              text ="Entrez la valeur de la rsistance, en ohms :").grid(row =2)
        Button(self.root, text ='Montrer',
               command =self.changeCouleurs).grid(row =3, sticky = W)
        Button(self.root, text ='Quitter',
               command =self.root.quit).grid(row =3, sticky = E)
        self.entree = Entry(self.root, width =14)
        self.entree.grid(row =3)
        # Code des couleurs pour les valeurs de zro  neuf :
        self.cc = ['black','brown','red','orange','yellow',
                   'green','blue','purple','grey','white']
        self.root.mainloop()

    def dessineResistance(self):
        """Canevas avec un modle de rsistance  trois lignes colores"""
        self.can = Canvas(self.root, width=250, height =100, bg ='light blue')
        self.can.grid(row =1, pady =5, padx =5)
        self.can.create_line(10, 50, 240, 50, width =5)         # fils
        self.can.create_rectangle(65, 30, 185, 70, fill ='beige', width =2)
        # Dessin des trois lignes colores (noires au dpart) :
        self.ligne =[]              # on mmorisera les trois lignes dans 1 liste
        for x in range(85,150,24):
            self.ligne.append(self.can.create_rectangle(x,30,x+12,70,
                                                        fill='black',width=0))

    def changeCouleurs(self):
        """Affichage des couleurs correspondant  la valeur entre"""
        self.v1ch = self.entree.get()       # la mthode get() renvoie une chane
        try:
            v = float(self.v1ch)            # conversion en valeur numrique
        except:
            err =1                          # erreur : entre non numrique
        else:
            err =0
        if err ==1 or v < 10 or v > 1e11 :
            self.signaleErreur()            # entre incorrecte ou hors limites
        else:
            li =[0]*3                       # liste des 3 codes  afficher
            logv = int(log10(v))            # partie entire du logarithme
            ordgr = 10**logv                # ordre de grandeur
            # extraction du premier chiffre significatif :
            li[0] = int(v/ordgr)            # partie entire
            decim = v/ordgr - li[0]         # partie dcimale
            # extraction du second chiffre significatif :
            li[1] = int(decim*10 +.5)       # +.5 pour arrondir correctement
            # nombre de zros  accoler aux 2 chiffres significatifs :
            li[2] = logv -1
            # Coloration des 3 lignes :
            for n in range(3):
                self.can.itemconfigure(self.ligne[n], fill =self.cc[li[n]])

    def signaleErreur(self):
        self.entree.configure(bg ='red')		# colorer le fond du champ
        self.root.after(1000, self.videEntree)		# aprs 1 seconde, effacer

    def videEntree(self):
        self.entree.configure(bg ='white')		# rtablir le fond blanc
        self.entree.delete(0, len(self.v1ch))		# enlever les car. prsents

# Programme principal :
if __name__ == '__main__':
    from Tkinter import *
    from math import log10                  # logarithmes en base 10
    f = Application()                       # instanciation de l'objet application
